<?php
require 'vendor/autoload.php';
// Database credentials
$db = new MysqliDb ('localhost', 'patientl_pullNum', 'pullNumbers', 'patientl_pullNumbers');
$mindate="SELECT DATE_FORMAT(MIN(STR_TO_DATE(date, '%m/%d/%Y')),'%m/%d/%Y') as mindate FROM pullnumbers";
$maxdate="SELECT DATE_FORMAT(MAX(STR_TO_DATE(date, '%m/%d/%Y')),'%m/%d/%Y') as maxdate  FROM pullnumbers WHERE STR_TO_DATE(date, '%m/%d/%Y') < '9999-09-09'";

$mindate = $db->ObjectBuilder()->rawQuery($mindate);
$maxdate = $db->ObjectBuilder()->rawQuery($maxdate);


?>

<!doctype html>
<html lang="en">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.css">

    <link href="style.css" rel="stylesheet">


    <title>Pull Numbers</title>

</head>
<body>
<div class="container">

<!--    <h1>Bootstrap grid examples</h1>-->
<!--    <p class="lead">Basic grid layouts to get you familiar with building within the Bootstrap grid system.</p>-->

    <h3>Select Date Range  </h3>
    <div class="form-group">
        <form id="how_many_records" method="post">

    <div class="row">

        <div class="col-md-4">
            <label for="fromdate">From Date</label>
            <input type="text" required id="fromdate" name="fromdate" class="form-control">

        </div>
        <div class="col-md-4">
            <label for="todate">To Date</label>
            <input type="text" required id="todate" name="todate" class="form-control">
        </div>

    </div>

    <div class="row">
        <img src="loading.gif">
       <button type="submit" class="btn btn-success">How Many Records</button>
    </div>
        </form>

        <form id="randomize_form" method="post">

            <div class="row">

                <div class="col-md-3">
                    <label for="total_records_found">Total Record Found</label>
                    <input type="number" required  readonly id="total_records_found" name="total_records_found" class="form-control">

                </div>
                <div class="col-md-2">
                    <label for="total_rows_found">Total Rows</label>
                    <input type="number" required  readonly id="total_rows_found" name="total_rows_found" class="form-control">

                </div>
                <div class="col-md-3">
                    <label for="randomize">No Of Rows to be Randomize</label>
                    <input type="number" required id="randomize" name="randomize" class="form-control">

                </div>

            </div>

            <div class="row">
                <img src="loading.gif">
                <button class="btn btn-success" type="submit">Randomize</button>
            </div>
        </form>
<div id="table">

</div>
    </div>

    <h3>Upload file  </h3>

    <div class="form-group">
        <form action="upload.php" method="post" name="uploadCSV"
              enctype="multipart/form-data">
            <div class="col-md-4">
                <label class=" control-label">Choose CSV File</label> <input
                        type="file" name="file" id="file" class="form-control" accept=".csv">



            </div>
            <button type="submit" id="submit" name="import"
                    class="btn-submit btn btn-success">Import</button>
            <div id="labelError"></div>
        </form>

    </div>

</div> <!-- /container -->

<script>
</script>
<!-- Optional JavaScript -->
<!-- jQuery first, then Popper.js, then Bootstrap JS -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.js"></script>

<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>


<script>
     disabledDates = ["09/09/999"];
     $("#fromdate").datepicker({
         dateFormat: "mm/dd/yy",
         changeMonth: true,
         changeYear: true,

         minDate: new Date('<?php if(isset($mindate[0])){echo $mindate[0]->mindate;}else{echo 0;} ?>'),
         maxDate: new Date('<?php if(isset($maxdate[0])){
                 echo $maxdate[0]->maxdate;

             }else{echo 0;} ?>'),
         onClose: function (selectedDate) {
             var date = $(this).datepicker('getDate'),
                 day=date.getDate(),
                 month = date.getMonth() + 1,
                 year = date.getFullYear();
             $("#todate").datepicker("option", "minDate", month + "/" + day + "/" + year);
         }
     });
     $("#todate").datepicker({
         dateFormat: "mm/dd/yy",
         changeMonth: true,
         changeYear: true,
         minDate: new Date('<?php if(isset($mindate[0])){echo $mindate[0]->mindate;}else{echo 0;} ?>'),
         maxDate: new Date('<?php if(isset($maxdate[0])){
                 echo $maxdate[0]->maxdate;

         }else{echo 0;} ?>'),
         onClose: function (selectedDate) {
             var date = $(this).datepicker('getDate'),
                 day = date.getDate(),
                 month = date.getMonth() + 1,
                 year = date.getFullYear();
             $("#fromdate").datepicker("option", "maxDate", selectedDate);
         }
     });

</script>
<script>

    $(document).ready(function () {

        $("img").hide();


        $('#how_many_records' ).submit( function( e ) {
            e.preventDefault();
                $.ajax( {
                    url:"logic.php?method=total",
                    type: 'POST',
                    data: new FormData( this ),
                    dataType : 'json',
                    processData: false,
                    contentType: false,
                    beforeSend:function(){
                        $("button").hide();
                        $("img").show();



                    },
                    complete:function(){
                        $("button").show();
                        $("img").hide();

                    },
                    success:function(response){
                        if(response.result =='true'){
                            $("#total_records_found").val(response.total_records_found);
                            $("#total_rows_found").val(response.total_rows_found);

                        }else {
                          $("#total_records_found").val(0);
                          $("#total_rows_found").val(0);
                            alert(response.message);
                        }

                    }
                } );
                e.preventDefault();

            }

        );
        $('#randomize_form' ).submit( function( e ) {

                e.preventDefault();
            var randomize=Number($("#randomize").val());
            var total_records_found=Number($("#total_rows_found").val());
            if(randomize=='0' &&  total_records_found=='0'){
                alert("Randomize value should be less than equal to total no of rows");
                return false
            }
            if(randomize > total_records_found ){
                alert("Randomize value should be less than equal to total no of rows");
                return false
            }else{
                $.ajax( {
                    url:"logic.php/?method=randomize",
                    type: 'POST',
                    data: new FormData( this ),
                    dataType : 'json',
                    processData: false,
                    contentType: false,
                    beforeSend:function(){
                        $("button").hide();
                        $("img").show();



                    },
                    complete:function(){
                        $("button").show();
                        $("img").hide();

                    },
                    success:function(response){
                        if(response.result =='true'){
                            $("#table").html(response.table);
                            $("#table").append('<div class="row">\n' +
                                '                <img src="loading.gif">\n' +
                                '                <a class="btn btn-success" href="allnumbers.php" id="allnumbers">Confirm</a>\n' +
                                '            </div>');
                        }else {
                          $("#table").html("");
                            alert(response.message);
                        }

                    }
                } );
            }



            }

        );

        $('body').on('click', '#allnumbers', function(e) {
                // escape here if the confirm is false;

                if (!confirm('Are you sure you want to proceed?')) return false;
            setTimeout(function() {
                document.location.href = 'list.php';
                return false;

            },3000);
            $("#allnumbers").hide();
            return true;

        });


    });

</script>
</body>
</html>
